/*
 * Decompiled with CFR 0.152.
 */
package threads;

import baby.GuiMidlet;
import baby.StanzaReader;
import com.twmacinta.util.MD5;
import jabber.presence.Presence;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import threads.IWriterThread;
import util.Datas;
import xmlstreamparser.HttpNode;
import xmlstreamparser.Node;

public class HttpBindThread
extends Thread
implements IWriterThread {
    public static int DEFAULT_WAIT = 30;
    private String httpburl;
    private int wait = DEFAULT_WAIT;
    private int polling = 5;
    protected boolean statusSet = false;
    private HttpConnection[] conn = new HttpConnection[2];
    private int defaultConn = 0;
    private long rid = -1L;
    private String sid = null;
    private Thread secondThread = null;
    private boolean ended = false;
    private boolean busy = false;
    private boolean terminated = false;
    private StanzaReader stanzaReader;
    private GuiMidlet eventsListener;
    private String buffer = "";

    public HttpBindThread(StanzaReader _stanzaReader, GuiMidlet events) {
        this.stanzaReader = _stanzaReader;
        this.eventsListener = events;
        this.start();
    }

    public void run() {
        String user = Datas.jid.getLittleJid();
        String domain = Datas.hostname;
        String addr = Datas.server_name + ":" + Datas.port;
        this.httpburl = "http://" + addr + "/http-bind/";
        System.out.println("Connecting..." + this.httpburl);
        try {
            this.initSession(addr, domain, user, Datas.getPassword(), "JabberMix", Presence.getPresence(1));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.ended = true;
        }
        if (this.ended) {
            this.terminate();
            return;
        }
        System.out.println("Successfully connected with " + addr);
        if (!this.ended) {
            this.stanzaReader.setRosterState();
            this.writeWithBody("<iq id=\"s3\" type=\"get\"><query xmlns=\"jabber:iq:roster\"/></iq>");
            this.readStanzas(0);
        }
        this.defaultConn = 1;
        this.statusSet = false;
        Date last = null;
        while (!this.ended) {
            try {
                if (this.terminated || this.busy) continue;
                Date now = new Date();
                if (last != null && now.getTime() - last.getTime() < (long)(this.polling * 1000)) {
                    HttpBindThread.sleep((long)(this.polling * 1000) - (now.getTime() - last.getTime()));
                }
                last = new Date();
                System.out.println("sending [" + last.toString() + "]: " + this.buffer);
                this.writeWithBody(this.buffer, 0);
                this.buffer = "";
                this.readStanzas(0);
                System.out.println("receiving  [" + new Date().toString() + "]");
            }
            catch (Exception e) {
                this.ended = true;
            }
        }
    }

    private synchronized void readStanzas(int connIdx) {
        HttpNode n = this.readResponse(connIdx);
        if (n == null) {
            return;
        }
        System.out.println("readStanzas: " + n.getChilds());
        int s = n.getChilds().size();
        for (int i = 0; i < s; ++i) {
            this.stanzaReader.read(new Node((HttpNode)n.getChilds().elementAt(i)));
        }
    }

    private HttpNode readStanza(int connIdx) {
        HttpNode n = this.readResponse(connIdx);
        int s = n.getChilds().size();
        if (s > 1) {
            return (HttpNode)n.getChilds().firstElement();
        }
        if (s < 1) {
            return new HttpNode();
        }
        return n;
    }

    protected HttpNode readStanza() {
        return this.readStanza(this.defaultConn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpNode readResponse(int connIdx) {
        this.busy = true;
        HttpNode x = new HttpNode();
        if (this.ended) {
            return null;
        }
        do {
            if (this.ended) continue;
            InputStream is = null;
            try {
                HttpConnection httpconn = this.conn[connIdx];
                int rc = httpconn.getResponseCode();
                if (rc == 404) {
                    HttpNode httpNode = null;
                    return httpNode;
                }
                if (rc != 200) {
                    int code;
                    is = httpconn.openInputStream();
                    while ((code = is.read()) != -1) {
                        System.out.print((char)code);
                    }
                    throw new Exception("Exception response code: " + rc);
                }
                is = httpconn.openInputStream();
                x.parse("", is);
            }
            catch (Exception e) {
                System.out.println("Exception reading response: " + e.getMessage());
                this.ended = true;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
            this.busy = false;
        } while (x.getName().equals("") && !this.ended);
        return x;
    }

    protected void initSession(String addr, String domain, String user, String pass, String resource, String Status) throws Exception {
        try {
            int inact;
            System.out.println("Opening first stream");
            this.generateRequestId();
            this.writeStream("<body content=\"text/xml; charset=utf-8\" to=\"" + domain + "\" hold=\"1\" wait=\"" + this.wait + "\" rid=\"" + this.rid + "\" " + "xml:lang=\"en\" " + "" + "route=\"xmpp:" + addr + "\" " + "xmlns=\"http://jabber.org/protocol/httpbind\" " + "/>", 0);
            HttpNode x = this.readResponse(0);
            if (!x.getName().equals("body")) {
                this.eventsListener.unauthorizedEvent("Body element missing!");
            }
            this.sid = x.getAttr("sid");
            System.out.println("Session creation response received: " + x.toString(0));
            if (this.sid == null || this.sid.length() == 0) {
                this.eventsListener.unauthorizedEvent("Session ID not given!");
                throw new Exception("Session ID not given!");
            }
            if (x.getAttr("requests") == null || x.getAttr("requests").equals("1")) {
                this.eventsListener.unauthorizedEvent("Server supports only polling behaviour!");
                throw new Exception("Server supports only polling behaviour!");
            }
            int tmpW = Integer.parseInt(x.getAttr("wait"));
            if (tmpW < this.wait) {
                this.wait = tmpW;
            }
            if (x.getAttr("polling") != null) {
                this.polling = Integer.parseInt(x.getAttr("polling"));
                ++this.polling;
            }
            if (x.getAttr("inactivity").length() > 0 && (inact = Integer.parseInt(x.getAttr("inactivity"))) < this.wait) {
                this.wait = inact;
            }
            System.out.println("Authenticating: " + x.toString());
            x = x.child("features");
            this.Authenticate(x, user, pass, domain);
            this.writeWithBody("<iq type=\"set\" id=\"bind_1\"><bind xmlns=\"urn:ietf:params:xml:ns:xmpp-bind\"><resource>" + resource + "</resource></bind></iq>");
            System.out.println("Binding resource");
            x = this.readStanza();
            if (x.getAttr("type").equals("error")) {
                this.eventsListener.unauthorizedEvent("Error binding resource");
                throw new Exception("Error binding resource");
            }
            this.writeWithBody("<iq to=\"" + domain + "\" type=\"set\" id=\"sess_1\">" + "<session xmlns=\"urn:ietf:params:xml:ns:xmpp-session\"/></iq>");
            System.out.println("Opening session");
            x = this.readStanza();
            if (x.getAttr("type").equals("error")) {
                this.eventsListener.unauthorizedEvent("Error opening session");
                throw new Exception("Error opening session");
            }
            System.out.println("Session Open!");
        }
        catch (Exception e) {
            this.eventsListener.unauthorizedEvent(e.getMessage());
            throw new Exception(e.getMessage());
        }
    }

    public synchronized void terminate() {
        this.wait = DEFAULT_WAIT;
        this.rid = -1L;
        this.sid = null;
        this.ended = true;
        this.terminated = true;
        this.defaultConn = 0;
        for (int i = 0; i < this.conn.length; ++i) {
            try {
                if (this.conn[i] == null) continue;
                this.conn[i].close();
                continue;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        this.eventsListener.disconnectedEvent();
        System.out.println("Terminated!");
    }

    public synchronized void write(final String _s) {
        System.out.println("Writing");
        while (this.secondThread != null && this.secondThread.isAlive()) {
            try {
                HttpBindThread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.secondThread = new Thread(){

            public void run() {
                HttpBindThread.this.writeWithBody(_s, 1);
                HttpBindThread.this.readStanzas(HttpBindThread.this.defaultConn);
            }
        };
        this.secondThread.start();
    }

    private void writeWithBody(String mess, int connIdx) {
        this.writeStream("<body rid=\"" + ++this.rid + "\" sid=\"" + this.sid + "\" " + "xmlns=\"http://jabber.org/protocol/httpbind\">" + mess + "</body>", connIdx);
    }

    protected void writeWithBody(final String mess) {
        if (this.defaultConn == 1) {
            while (this.secondThread != null && this.secondThread.isAlive()) {
                try {
                    HttpBindThread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.secondThread = new Thread(){

                public void run() {
                    HttpBindThread.this.writeWithBody(mess, HttpBindThread.this.defaultConn);
                    HttpBindThread.this.readStanzas(HttpBindThread.this.defaultConn);
                }
            };
            this.secondThread.start();
        } else {
            this.writeWithBody(mess, this.defaultConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(String mess, int connIdx) {
        if (this.ended) {
            this.terminate();
            return;
        }
        OutputStream out = null;
        try {
            HttpConnection httpconn;
            byte[] bout = this.unicodeToServer(mess);
            this.conn[connIdx] = httpconn = (HttpConnection)Connector.open((String)this.httpburl);
            if (!this.httpburl.startsWith("https://")) {
                httpconn.setRequestProperty("User-Agent", "Profile/MIDP-2.0 Configuration/CLDC-1.1");
            }
            httpconn.setRequestMethod("POST");
            httpconn.setRequestProperty("Content-Length", "" + bout.length);
            out = httpconn.openOutputStream();
            if (out != null) {
                out.write(bout);
            }
            System.out.println("writtenToAir [" + connIdx + "]: " + mess);
        }
        catch (Exception e) {
            System.out.println("Exception found: " + e.getMessage());
            this.ended = true;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private long generateRequestId() {
        String strRid = "";
        Random r = new Random();
        for (int i = 0; i < 10; ++i) {
            int anu = r.nextInt();
            String m = Integer.toString(anu);
            strRid = strRid + "" + m;
        }
        this.rid = Long.parseLong(strRid);
        return this.rid;
    }

    protected void Authenticate(HttpNode x, String user, String pass, String domain) throws Exception {
        if (x.child("mechanisms").hasValueOfChild("PLAIN")) {
            System.out.println("Using plain authorization");
            String resp = "\u0000" + user + "\u0000" + pass;
            this.writeWithBody("<auth xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\" mechanism=\"PLAIN\">" + MD5.toBase64(resp.getBytes()) + "</auth>");
            System.out.println("Starting PLAIN authorization");
            x = this.readStanza();
            if (x.getName().equals("failure")) {
                throw new Exception("PLAIN authorization error");
            }
        } else {
            throw new Exception("Only PLAIN authorization supported");
        }
    }

    public byte[] unicodeToServer(String s) {
        byte[] b = new byte[HttpBindThread.strlen(s)];
        char[] a = s.toCharArray();
        int j = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < '\u0080') {
                b[j] = (byte)a[i];
                ++j;
                continue;
            }
            if (a[i] < '\u0800') {
                b[j] = (byte)(0xC0 | a[i] >> 6);
                b[j + 1] = (byte)(0x80 | a[i] & 0x3F);
                j += 2;
                continue;
            }
            b[j] = (byte)(0xE0 | a[i] >> 12);
            b[j + 1] = (byte)(0x80 | a[i] >> 6 & 0x3F);
            b[j + 2] = (byte)(0x80 | a[i] & 0x3F);
            j += 3;
        }
        return b;
    }

    public static int strlen(String s) {
        int n = 0;
        char[] a = s.toCharArray();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < '\u0080') {
                ++n;
                continue;
            }
            if (a[i] < '\u0800') {
                n += 2;
                continue;
            }
            n += 3;
        }
        return n;
    }
}

