/*
 * Decompiled with CFR 0.152.
 */
package jabber.conversation;

import jabber.roster.Jid;
import util.Datas;
import util.Util;
import xmlstreamparser.Node;

public class Message {
    private boolean processed = false;
    private boolean smile_processed = false;
    public String subject;
    public String body;
    public String from;

    public Message(String _subject, String _body) {
        this.subject = _subject;
        this.body = _body;
        this.from = Datas.jid.getUsername();
    }

    public Message(String _subject, String _body, String _from) {
        this.subject = _subject;
        this.body = _body;
        this.from = _from;
    }

    public Message(Node _node) {
        this.subject = "";
        if (_node.getChild("subject") != null) {
            this.subject = _node.getChild((String)"subject").text;
        }
        this.body = "";
        if (_node.getChild("body") != null) {
            this.body = _node.getChild((String)"body").text;
        }
        if (_node.getValue("from") != null) {
            this.from = _node.getValue("from");
        }
    }

    public String getText() {
        StringBuffer res = new StringBuffer();
        if (this.subject.equals("")) {
            if (!this.smile_processed) {
                this.body = Message.setSmiles(this.body);
                this.smile_processed = true;
            }
            if (!this.processed) {
                this.body = Message.setLink(this.body);
                this.processed = true;
            }
            res.append(Jid.getUsername(this.from)).append(">").append(this.body).append("\n");
        } else if (this.body.equals("")) {
            res.append(Jid.getUsername(this.from)).append(">").append(this.subject);
        } else {
            if (!this.smile_processed) {
                this.body = Message.setSmiles(this.body);
                this.smile_processed = true;
            }
            res.append(Jid.getUsername(this.from)).append(">").append(this.subject).append("\n").append(this.body).append("\n");
        }
        return res.toString();
    }

    public String getTextNick() {
        StringBuffer res = new StringBuffer();
        int i = this.from.indexOf("/");
        String jid = i != -1 ? this.from.substring(i + 1, this.from.length()) : Jid.getUsername(this.from);
        if (this.subject.equals("")) {
            if (!this.smile_processed) {
                this.body = Message.setSmiles(this.body);
                this.smile_processed = true;
            }
            if (!this.processed) {
                this.body = Message.setLink(this.body);
                this.processed = true;
            }
            res.append(jid).append(">").append(this.body).append("\n");
        } else if (this.body.equals("")) {
            res.append(jid).append(">").append(this.subject);
        } else {
            if (!this.smile_processed) {
                this.body = Message.setSmiles(this.body);
                this.smile_processed = true;
            }
            res.append(jid).append(">").append(this.subject).append("\n").append(this.body).append("\n");
        }
        return res.toString();
    }

    public String getTextAsXML() {
        StringBuffer res = new StringBuffer();
        if (!this.subject.equals("")) {
            res.append("<subject>").append(Util.escapeCDATA(this.subject)).append("</subject>");
        }
        if (!this.body.equals("")) {
            res.append("<body>").append(Util.escapeCDATA(this.body)).append("</body>");
        }
        String xml = res.toString();
        return xml;
    }

    public static String setSmiles(String body) {
        int i = -1;
        i = body.indexOf(":)");
        if (i != -1 || (i = body.indexOf(":-)")) != -1) {
            body = body.substring(0, i) + "1smile1 " + body.substring(body.indexOf(")", i) + 1, body.length());
        } else {
            i = body.indexOf(":(");
            if (i != -1 || (i = body.indexOf(":-(")) != -1) {
                body = body.substring(0, i) + "1smile2 " + body.substring(body.indexOf("(", i) + 1, body.length());
            } else {
                i = body.indexOf(":D");
                if (i != -1) {
                    body = body.substring(0, i) + "1smile3 " + body.substring(body.indexOf("D", i) + 1, body.length());
                } else {
                    i = body.indexOf(":P");
                    if (i != -1) {
                        body = body.substring(0, i) + "1smile4 " + body.substring(body.indexOf("P", i) + 1, body.length());
                    }
                }
            }
        }
        return body;
    }

    public static String setLink(String body) {
        int i = -1;
        i = body.indexOf("http://");
        if (i != -1 || (i = body.indexOf("https://")) != -1) {
            int end = body.indexOf(" ", i);
            if (end == -1) {
                end = body.length();
            }
            body = body.substring(0, i) + "+url+" + body.substring(i, end) + "-url-" + body.substring(end, body.length());
        }
        return body;
    }

    public void addError(String error_text) {
        this.body = this.body + "\n" + error_text;
    }
}

